-- Thanks you dbk2 & Kyzentun for this Script!
local pn = ...
local pName = ToEnumShortString(pn)
local mods = MetroQuad[pName].ActiveModifiers
local streams = MetroQuad[pName].Streams
local PlayerState = GAMESTATE:GetPlayerState(pn)

local current_measure, previous_measure
local MeasureCounterBMT

local current_count = 0
local stream_index = 1
local current_stream_length = 0

local function Update(self, delta)

	if not streams.Measures then return end

	current_measure = (math.floor(PlayerState:GetSongPosition():GetSongBeatVisible()))/4

	-- previous_measure will initially be nil; set it to be the same as current_measure
	if not previous_measure then previous_measure = current_measure end

	local new_measure_has_occurred = current_measure > previous_measure

	if new_measure_has_occurred then

		previous_measure = current_measure

		-- if the current measure is within the of the current stream
		if streams.Measures[stream_index]
		and current_measure >= streams.Measures[stream_index].streamStart
		and current_measure <= streams.Measures[stream_index].streamEnd then

			current_stream_length = streams.Measures[stream_index].streamEnd - streams.Measures[stream_index].streamStart
			current_count = math.floor(current_measure - streams.Measures[stream_index].streamStart) + 1

			text = tostring(current_count .. "/" .. current_stream_length + 1)
			MeasureCounterBMT:settext( text )

			if current_count > current_stream_length then
				stream_index = stream_index + 1
				MeasureCounterBMT:settext( text )
			end
		else
			MeasureCounterBMT:settext("")
		end
	end

	return
end

local function XPosition(pn)
	local style = ToEnumShortString(GetCurrentStyle():GetStyleType())
	local sName = GetCurrentStyle():GetName()
	local pos
	if pn == PLAYER_1 then
		if sName == "solo" then return Left()+64 end
		if style == "OnePlayerOneSide" then
			pos = Left()+40
		elseif style == "TwoPlayersTwoSides" then
			pos = Left()+40
		elseif style == "OnePlayerTwoSides" then
			pos = Left()+64
		end
	end
	if pn == PLAYER_2 then
		if sName == "solo" then return Left()+64 end
		if style == "OnePlayerOneSide" then
			pos = CenterX()+78
		elseif style == "TwoPlayersTwoSides" then
			pos = CenterX()+40
		elseif style == "OnePlayerTwoSides" then
			pos = Left()+64
		end
	end
	return pos
end

if mods.MeasureCounter and mods.MeasureCounter ~= "None" then

	local af = Def.ActorFrame{
		InitCommand=function(self)
			self:queuecommand("SetUpdate")
		end,
		SetUpdateCommand=function(self)
			self:SetUpdateFunction( Update )
		end
	}

	af[#af+1] = Def.BitmapText{
		Font="Common Normal",
		InitCommand=function(self)
			MeasureCounterBMT = self

			local style = GAMESTATE:GetCurrentStyle(pn)
			local width = style:GetWidth(pn)
			local NumColumns = GAMESTATE:GetCurrentStyle():ColumnsPerPlayer()

			self:zoom(0.5):xy(XPosition(pn),Top()+150):halign(0)
		end
	}

	return af

else
	return af
end
